using System;
using Server.Items;

namespace Server.Items
{
	public class ScepterOfTheChief : Scepter
	{
		public override int LabelNumber{ get{ return 1072080; } } // Scepter of the Chief
		public override int AosStrengthReq{ get{ return 40; } }
		public override int AosMinDamage{ get{ return 14; } }
		public override int AosMaxDamage{ get{ return 17; } }
		public override int AosSpeed{ get{ return 30; } }

		public override int OldStrengthReq{ get{ return 40; } }
		public override int OldMinDamage{ get{ return 14; } }
		public override int OldMaxDamage{ get{ return 17; } }
		public override int OldSpeed{ get{ return 30; } }

		public override int InitMinHits{ get{ return 75; } }
		public override int InitMaxHits{ get{ return 75; } }
		
      [Constructable]
		public ScepterOfTheChief() : base()
		{
			Hue = 0x481;
			
			Slayer2 = SlayerName.Exorcism;
			
			Attributes.RegenHits = 2;
			Attributes.ReflectPhysical = 15;
			Attributes.WeaponDamage = 45;
			
			WeaponAttributes.HitDispel = 100;
			WeaponAttributes.HitLeechMana = 60;
		}

		public ScepterOfTheChief( Serial serial ) : base( serial )
		{
		}
		
		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			phys = fire = cold = nrgy = 0;
			pois = 100;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}